
/**
 ******************************************************************************
 *
 * @file        MG32_USBD_Descriptor_API.c
 * @brief       USB description file. 
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2020/06/05
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */



/* Includes ------------------------------------------------------------------*/
#include "MG32_USBD_Core.h"
#include "MG32_USB_Init.h"
#include "MG32_USBD_Descriptor.h"
#include "MG32_USBD_Audio_Core.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
const uint8_t USB_HID_REPORT[] = 
{
    0x06,0x00, 0xFF,                             // USAGE_PAGE ( Vendor Defined Page 1 )
    0x09,0x01,                                   // USAGE ( Vendor Usage 1 )
    0xA1,0x01,                                   // Collection ( Application )
      0x09,0x01,                                 // Usage (Vendor Usage 1)
      0x15,0x00,                                 // Logical Minimum (0)
      0x26,0xFF,0x00,                            // Logical Maximum (255)
      0x95, 0x40,                                // Report_Count ( 64 )
      0x75,0x08,                                 // Report_Size ( 8 )
      0xB1,0x02,                                 // Feature (Data, Var, Absolute)
    0xC0,
};


const uint8_t USB_HID_REPORT2[] =
{
    0x05,0x0C,      // USAGE_PAGE ( Consumer)
    0x09,0x01,      // USAGE ( Consumer Control)
    0xA1,0x01,      // COLLECTION (Application)

    0x85,0x01,      // Report ID 01
    0x15,0x00,      // LOGICAL_MINIMUM (0)
    0x25,0x01,      // LOGICAL_MAXIMUM (1)
    
    0x75,0x01,      // Report Size (1)
    0x95,0x07,      // Report Count(7)

    0x09,0xE9,      // USAGE (Volume Up)
    0x09,0xEA,      // USAGE (Volume Down)
    0x09,0xCD,      // USAGE(Play / Pause)
    0x09,0xB5,      // USAGE(Next Track)
    0x09,0xB6,      // USAGE(Previous Track)
    0x09,0xB7,      // USAGE(Stop)
    0x09,0xE2,      // USAGE(Mute)

    0x81,0x02,      // INPUT( Data , Var, Abs)

    0x75,0x01,      // Report Size (1)    
    0x95,0x01,      // Report Count(1)
    0x81,0x03,      // Input (Cnst,Var, Abs)

    0xC0,

    0x05,0x0B,      // USAGE_PAGE (Telephony Devices)
    0x09,0x05,      // USAGE (Headset)
    0xA1,0x01,      // COLLECTION (Application)

    0x85,0x02,      // Report ID 02
    0x15,0x00,      // LOGICAL_MINIMUM (0)
    0x25,0x01,      // LOGICAL_MAXIMUM (1)
    0x95,0x01,      // Report Count(1)
    0x75,0x01,      // Report Size(1)
    0x09,0x20,      // USAGE (Hook Switch)
    0x81,0x23,      // INPUT( Cnst,Var,Abs,NPrf)
    0x95,0x01,      // Report Count(1)
    0x75,0x07,      // Report Size(7)
    0x81,0x03,      // INPUT(Cnst,Var, Abs)

    0xC0,
};

/**
 *************************************************************************************************************
 * @fn       	DEVICE Descriptor  relationship 
 * @param    	No
 * @return      No
 * @details    	//-----------------USB 2.0------------------------------
				0: 		bLength 			Number		Size of this descriptor in bytes
				1: 		bDescriptorType		Constant	DEVICE Descriptor Type
				2,3: 	bcdUSB		    	BCD			USB specification release number in Binary-coded Decimal.
														This field identifies the release of the USB specification with
														which the device and its descriptors are compliant
				4:		bDeviceClass		Class		Class code:
														(1) If this field is reset to zero, each interface within a configuration 
															specifies its own class information and the various inerfaces operate
															independently
														(2) If this field is set to a value between 1 and 0xFE, the device supports 
															different class specifications on different interfaces and the 
															interfaces may not operate independently. This value identifies the 
															class definition used for the aggregate interfaces
														(3) If this field is set to 0xFF, the device class is vendor-specific
				5:      bDeviceSubClass 	Subclass	Subclass code
														(1) These codes are qualified by the value of the bDeviceClass field
														(2) If the bDeviceClass field is reset zero this field must alse be reset
															to zero.
														(3) If the bDeviceClass field is not set to 0xFF, all values are reserved 
															for assignment by the USB-IF.
				6:		bDeviceProtocol		Protocol    Protocol code
														(1) These codes are qualified by the value of the bDeviceSubClass fields.
															and the bDeviceSubClass field.
														(2) If a device supports class-specific protocols on a device basis  as 
															opposed to an interface basis, this code identifies the protocols 
															that the device uses as defined by the specification of the device class.
														(3) If this field is reset to zero, the device does not use class-specific 
															protocols on a device basis. However, it may use class-specific 
															protocols on an interface basis
														(4) If this field is set to 0xFF, the device uses a vendor-specific
															protocol on a device basis.
				7:		bMaxPacketSize0 	Number  	Maximum packet size for endpoint zero(only 8,16,32,or 64 are valid)
				8,9:    idVendor        	ID			VendorID(assigned by the USB-IF)
				10,11:  idProduct       	ID			Product ID(assigned by the manufacturer)
				12,13:  bcdDevice			BCD			Device release number in binary coded decimal
				14:     iManufacturer   	Index		Index of string descriptor describing manufacturer
				15:     iProduct        	Index 		Index of string descriptor describing product
				16:     iSerialNumber   	Index 		Index of string descriptor describing the device's serial number
				17:     bNumConfigurations	Number      Number of possible configurations
 **************************************************************************************************************
 */ 
const uint8_t USB_DEVICE_DESCRIPTOR[]=
{ 
    0x12,                                        // 0:  bLength
    DEVICE_DESCRIPTOR,                           // 1:  bDescriptorType (0x01 = Device)
    0x01,                                        // 2:  bcdUSB(LSB)
    0x01,                                        //     bcdUSB(MSB)
    0x00,                                        // 4:  bDeviceClass
    0x00,                                        // 5:  bDevice SubClass
    0x00,                                        // 6:  bDeviceProtocol
    EP0_PACKET_SIZE,                             // 7:  bMaxPacketSize
    LOBYTE( USB_VID ),                           // 8:  idVendor(LSB)
    HIBYTE( USB_VID ),                           //     idVendor(MSB)
    LOBYTE( USB_PID ),                           // 10: idProduct(LSB)
    HIBYTE( USB_PID ),                           //     idProduct(MSB)
    LOBYTE( USB_DID ),                           // 12: bcdDevice(LSB)
    HIBYTE( USB_DID ),                           //     bcdDevice(MSB)
#ifdef MF_STRING
    0x01,                                        // 14: iManufacture (String Index)
#endif
#ifndef MF_STRING
    0x00,                                        // 14: iManufacture (String Index)
#endif
#ifdef PD_STRING
    0x02,                                        // 15: iProduct     (String Index)
#endif
#ifndef PD_STRING
    0x00,                                        // 15: iProduct     (String Index)
#endif
#ifdef SN_STRING    
    0x03,                                        // 16: iSerialNumber(String Index)
#endif
#ifndef SN_STRING    
    0x00,                                        // 16: iSerialNumber(String Index)
#endif
    0x01                                         // 17: bNumConfigurations
};

/**
 ***************************************************************************************************************
 * @fn       	Configuartion Descriptor  relationship 
 * @param    	
 * @return      
 * @details    	//-----------------USB 2.0------------------------------
				0:		bLength				Number		Size of this descriptor in bytes
				1:		bDescriptorType		Constant	CONFIGURATION Descriptor Type
				2,3:	wTotalLength        Number      Total length of data returned for this configuration.
														Includes the combined length of all descriptros
														(configuration,interface,endpoint,and class- or vendor-
														specific)returned for this configuration.
				4:		bNumInterface		Number      Number of interfaces supported by this configuration
				5:		bConfigurationValue	Number      Value to use as an argument to the SetConfiguration()
														request to select this configuration
				6:		iConfiguration 		Index		Index of string descriptor describing this configuration
				7:		bmAttributes 		Bitmap		Configuration characteristics
														(1) D7:Reserved (must be set to one for historical reasons
															D6:Self-powered
															D5:Remote Wakeup
															D4~D0:Reserved(reset to zero)
														(2) A device configuration that uses power from the bus and
														    a local source reports a non-zero value in bMaxPower to 
															indicate the amount of bus power required and set D6.
															The actual power source at runtime may be determined 
															using the GetStatus(DEVICE) requet.
														(3) If a device configuration supports remote wakeup, D5
															is set to one.
				8:		bMaxPower			mA			(1) Maximum power consumption of the USB device from the 
															bus in this specific configuration when the device is 
															fully operational.Expressed in 2mA uints
														    Note:
																A device configuration reports wehter the configuration
																is bus-powered or self-powered.Device status report
																wether the device is currently self-powered. Device 
																status reports whether the device is currently 
																self-powered. If a device is disconnected from its
																external power source, it updates device status to
																indicate that it is no longer self-powered
														(2) A device may not increase its power draw from the bus
														    ,where it loses its external power source, beyond the
															amount reported by its configuration
														(3) If a device can continue to operate when disconnected 
														    from its external power source, it continues to do so.
															If fails operations it can no longer support.
															The USB system software may determine the cause of the
															failure by checking the status and noting the loss of the
															device's power source
 ***************************************************************************************************************
 */ 
const uint8_t USB_CONGFIGURATION_DESCRIPTOR[]=
{ 
    0x09,                                        // 0:  bLength
    CONFIGURATION_DESCRIPTOR,                    // 1:  bDescriptorType (0x02 = configuration )
    LOBYTE( USB_CONFIGURATION_DESC_TOTAOSIZE ),  // 2:  wTotalLength(LSB)(All Descriptor ,
    HIBYTE( USB_CONFIGURATION_DESC_TOTAOSIZE ),  // 3:  wTotalLength(MSB)(Exclude "String")
    USB_CONFIGURATION_TOTAOL_INTERFACE,          // 4:  bNumInterface
    0x01,                                        // 5:  bConfigurationValue
    0x00,                                        // 6:  iConfiguration (String Index)
    0x80,                                        // 7:  bmAttributes (Bus power & Remote wakeup)
                                                 //     D7:      Reserved (Set to one)
                                                 //     D6:      Self Powered
                                                 //     D5:      Remote Wakeup
                                                 //     D4..0:   Reserved (Reset to 0)
    0x32,                                        // 8:  Power    (100mA)
    //=============================================
    //Custom Define HID Interface
    #if 1
        0x09,                                        // 0:  bLength
        INTERFACE_DESCRIPTOR,                        // 1:  bDescriptorType
        0x00,                                        // 2:  bInterfaceNumber
        0x00,                                        // 3:  bAlternateSetting
        0x00,                                        // 4:  bNumEndpoints
        0x03,                                        // 5:  bInterfaceClass
        0x00,                                        // 6:  bInterfaceSubClass
        0x00,                                        // 7:  bInterfaceProtocol
        0x00,                                        // 8:  iInterface         (String Index)
        //---------------------------------------------
        0x09,                                        // 0:  bLength
        HID_DESCRIPTOR,                              // 1:  bDescriptorType (0x22 = HID)
        0x00,                                        // 2:  bcdHIDClassL
        0x01,                                        // 3:  bcdHIDClassH
        0x00,                                        // 4:  Hardware Target Country
        0x01,                                        // 5:  Number of HID class descriptor to follow
        0x22,                                        // 6:  Report descriptor type
        LOBYTE( HID_REPORT_SIZE ),                  
        HIBYTE( HID_REPORT_SIZE ),                  
    #endif
    
    //=============================================
    // Audio Control (AC) Interface Descriptor
    #if 1
        //---------------------------------------------
        //Standard AC Interface Descriptor
        0x09,
        INTERFACE_DESCRIPTOR,
        0x01,                                            // 2 : bInterfaceNumber   : Number of the AudioControl interface.
        0x00,                                            // 3 : bAlternateSetting  : The AudioControl interface of the headphone only supports the default.                       
        0x00,                                            // 4 : bNumEndpoints      : A status interrupt endpoint is not allowed.
        AUDIO_INTERFACE_CLASS_AUDIO,                     // 5 : bInterfaceClass    
        AUDIO_INTERFACE_SUCLASS_AUDIOCONTROL,            // 6 : bInterfaceSubClass
        AUDIO_INTERFACE_PROTOCOL_IP_VER_01_00,           // 7 : bInterfaceProtocol
        0x00,                                            // 8 : iInterface
        //----------------------------------------------
        // Class Interface Descriptor (AC)
        0x0A,
        CS_INTERFACE_DESCRIPTOR,
        CS_INTERFACE_SUBTYPE_HEADER,
        
        0x00,                                             // 3 : bcdADC 
        0x01,
        
        0x52,                                             // 5 : wTotalLength
        0x00,
        
        0x02,                                             // 7  : 2 AudioStreaming interface in the Collection.
        
        0x02,                                             // 8  : Interface number of the first AudioStreaming interface in the collection. 
        
        0x03,                                             // 9  : Interface number of the second AudioStreaming interface in the collection.
        //----------------------------------------------
        // Input Terminal ID 1 Descriptor.
        0x0C,
        CS_INTERFACE_DESCRIPTOR,
        CS_INTERFACE_SUBTYPE_INPUT_TERMINAL,
        
        0x01,  //ID
        
        LOBYTE( USB_TERMINAL_TYPE_STREAMING),
        HIBYTE( USB_TERMINAL_TYPE_STREAMING),
        
        0x00,
        
        0x02,
        
        0x03,
        0x00,
        
        0x00,
        
        0x00,
        //----------------------------------------------
        // Input Terminal ID 2 Descriptor
        0x0C,
        CS_INTERFACE_DESCRIPTOR,
        CS_INTERFACE_SUBTYPE_INPUT_TERMINAL,
        
        0x02,  //ID
        
        LOBYTE( INPUT_TERMINAL_TYPE_MICROPHONE),
        HIBYTE( INPUT_TERMINAL_TYPE_MICROPHONE),
        
        0x00,
        
        0x02,
        
        0x03,
        0x00,
        
        0x00,
        
        0x00,
        //----------------------------------------------
        // Output terminal ID 6 Descriptor.
        0x09,
        CS_INTERFACE_DESCRIPTOR,
        CS_INTERFACE_SUBTYPE_OUTPUT_TERMINAL,
        
        0x06,                                      //bTerminalID
        
        LOBYTE( OUTPUT_TERMINAL_TYPE_SPEAKER),     //wTerminalType
        HIBYTE( OUTPUT_TERMINAL_TYPE_SPEAKER),
        
        0x00,                                      //bAssocTerminal
        
        0x09,                                      //bSourceID
        
        0x00,                                      //iTerminal 
        //----------------------------------------------
        // Output terminal ID 7 Descriptor.
        0x09,
        CS_INTERFACE_DESCRIPTOR,
        CS_INTERFACE_SUBTYPE_OUTPUT_TERMINAL,
        
        0x07,                                      //bTerminalID
        
        LOBYTE( USB_TERMINAL_TYPE_STREAMING),      //wTerminalType
        HIBYTE( USB_TERMINAL_TYPE_STREAMING),
        
        0x00,                                      //bAssocTerminal
        
        0x08,                                      //bSourceID
        
        0x00,                                      //iTerminal       
        //----------------------------------------------
        //Selector Unit ID8 Descriptor
        0x07,
        CS_INTERFACE_DESCRIPTOR,
        CS_INTERFACE_SUBTYPE_SELECTOR_UNIT,
        
        0x08,                                       // bUnitID 
        
        0x01,                                       // bNrInPins
        
        0x0A,                                       // baSourceID(1)
        
        0x00,                                       // iSelector
        //----------------------------------------------
        //Feature Unit ID9 Descriptor
        0x0D,
        
        CS_INTERFACE_DESCRIPTOR,
        
        CS_INTERFACE_SUBTYPE_FEATURE_UNIT,
        
        0x09,                                       // ID
        
        0x01,                                       // bSourceID  :                                
        
        0x02,                                       // bControlSize : Size in bytes of an element of the bmaControls() array : n
        
        0x01,                                       // bmaControls(0) : Mute
        
        0x00,                                       // bmaControls(0)
        
        0x02,                                       // bmaControls(1) : Volume Control on Left Front channel.
        
        0x00,                                       // bmaControls(1)
        
        0x02,                                       // bmaControls(2) : Volume Control on Right Front channel.
        
        0x00,                                       // bmaControls(2)
        
        0x00,                                       // iFeature : Index of a string descriptor.
        //----------------------------------------------
        //Feature Unit ID10 Descriptor.
        0x0A,
        
        CS_INTERFACE_DESCRIPTOR,
        
        CS_INTERFACE_SUBTYPE_FEATURE_UNIT,
        
        0x0A,                                        // ID
                                                     
        0x02,                                        // bSourceID  : 
                                                     
        0x01,                                        // bControlSize : Size in bytes of an element of the bmaControls() array : n
                                                     
        0x01,                                        // bmaControls(0) : Mute
                                                     
        0x02,                                        // bmaControls(1) : Volume
                                                     
        0x02,                                        // bmaControls(2) : Volume
                                                     
        0x00,                                        // iFeature : Index of a string descriptor. 
    #endif
    //=============================================
    //Audio Streaming (AS) Interface Descriptor (Audio OUT)
    #if 1
        //----------------------------------------------
        //Standard Interface Descriptor (AS zero bandwidth) (OUT)
        0x09,
        INTERFACE_DESCRIPTOR,
        0x02,
        0x00,
        0x00,
        AUDIO_INTERFACE_CLASS_AUDIO,
        AUDIO_INTERFACE_SUCLASS_AUDIOSTREAMING,
        AUDIO_INTERFACE_PROTOCOL_IP_VER_01_00,
        0x00,
        //----------------------------------------------
        //Standard Interface Descriptor (AS)
        0x09,
        INTERFACE_DESCRIPTOR,
        0x02,
        0x01,
        0x01,
        AUDIO_INTERFACE_CLASS_AUDIO,
        AUDIO_INTERFACE_SUCLASS_AUDIOSTREAMING,
        AUDIO_INTERFACE_PROTOCOL_IP_VER_01_00,
        0x00,
        //----------------------------------------------
        //Class Interface Descriptor (AS)
        0x07,
        CS_INTERFACE_DESCRIPTOR,
        AS_INTERFACE_SUBTYPE_GENERAL,
        
        0x01,
        
        0x01,
        
        0x01,
        0x00,
        //----------------------------------------------
        //Class Interface Descriptor ( AS Format )
        0x0E,
        CS_INTERFACE_DESCRIPTOR,
        AS_INTERFACE_VALID_FREQ_RANGE,
        
        0x01,                                                                                  //bFormatType   : Type I
                                                                                               
        OUT_Channel,                                                                           //bNrChannels   : 
                                                                                               
        0x02,                                                                                  //bSubframeSize :
                                                                                               
        OUT_BitResolution,                                                                     //bBitResolution :
                                                                                               
        0x02,                                                                                  //bSamFreqType   :
                                                                                               
                                                                                               
        AUDIO_SAM_FREQ_BYTE0(OUT_tLowSamFreq),                                                 //Lower bound in Hz of the sampling freq range.
        AUDIO_SAM_FREQ_BYTE1(OUT_tLowSamFreq),                                                 
        AUDIO_SAM_FREQ_BYTE2(OUT_tLowSamFreq),                                                 
                                                                                               
        AUDIO_SAM_FREQ_BYTE0(OUT_tUpperSamFreq),                                               //Upper bound in Hz of the sampling freq range.
        AUDIO_SAM_FREQ_BYTE1(OUT_tUpperSamFreq),
        AUDIO_SAM_FREQ_BYTE2(OUT_tUpperSamFreq),
        
        //----------------------------------------------
        //Standard endpoint descriptor
        0x09,
        ENDPOINT_DESCRIPTOR,
        
        (USB_EP_OUT | USB_EP_1),
        
        (USB_EP_ISOCHRONOUS | USB_EP_SYNC | USB_EP_DATA),
        
        #if IN_tUpperSamFreq != 44100 && IN_tUpperSamFreq!= 22050
            LOBYTE( AUDIO_EP_SIZE( OUT_tUpperSamFreq, OUT_BitResolution , OUT_Channel)),       // wMaxPacketSize
            HIBYTE( AUDIO_EP_SIZE( OUT_tUpperSamFreq, OUT_BitResolution , OUT_Channel)),
        #else
            LOBYTE( AUDIO_EP_SIZE2( OUT_tUpperSamFreq, OUT_BitResolution , OUT_Channel)),      // wMaxPacketSize
            HIBYTE( AUDIO_EP_SIZE2( OUT_tUpperSamFreq, OUT_BitResolution , OUT_Channel)),        
        #endif
        
        0x01,                                                                                  // bInterval 
                                                                                               
        0x00,                                                                                  // bRefresh
                                                                                               
        0x00,                                                                                  // bSynchAddress
        //----------------------------------------------
        //Class endpoint descriptor.
        0x07,
        CS_ENDPOINT_DESCRIPTOR,
        0x01,0x01,0x00,0x00,0x00,
    
    #endif
    //=============================================
    //Audio Streaming (AS) Interface Descriptor (Audio IN)
    #if 1
        //----------------------------------------------
        //Standard Interface Descriptor (AS zero bandwidth) 
        0x09,
        INTERFACE_DESCRIPTOR,
        0x03,
        0x00,
        0x00,
        0x01,
        0x02,
        0x00,
        0x00,
        //----------------------------------------------
        //Standard Interface Descriptor
        0x09,
        INTERFACE_DESCRIPTOR,
        0x03,
        0x01,
        0x01,
        0x01,
        0x02,
        0x00,
        0x00,
        //----------------------------------------------
        0x07,
        CS_INTERFACE_DESCRIPTOR,
        AS_INTERFACE_SUBTYPE_GENERAL,
        0x07,
        0x01,
        0x01,
        0x00,
        //----------------------------------------------
        0x0E,
        CS_INTERFACE_DESCRIPTOR,
        AS_INTERFACE_VALID_FREQ_RANGE,
        
        0x01,
        
        IN_Channel,
        
        0x02,
        
        IN_BitResolution,
        
        0x02,
        
        AUDIO_SAM_FREQ_BYTE0(IN_tLowSamFreq),                                              //Lower bound in Hz of the sampling freq range.
        AUDIO_SAM_FREQ_BYTE1(IN_tLowSamFreq),                                              
        AUDIO_SAM_FREQ_BYTE2(IN_tLowSamFreq),                                              
                                                                                           
        AUDIO_SAM_FREQ_BYTE0(IN_tUpperSamFreq),                                            //Upper bound in Hz of the sampling freq range.
        AUDIO_SAM_FREQ_BYTE1(IN_tUpperSamFreq),
        AUDIO_SAM_FREQ_BYTE2(IN_tUpperSamFreq),
        //----------------------------------------------
        0x09,
        ENDPOINT_DESCRIPTOR,
        (USB_EP_IN | USB_EP_2),
        (USB_EP_ISOCHRONOUS | USB_EP_ASYNC | USB_EP_DATA),
        
        #if IN_tUpperSamFreq != 44100 && IN_tUpperSamFreq!= 22050
            LOBYTE( AUDIO_EP_SIZE( IN_tUpperSamFreq, IN_BitResolution , IN_Channel)),      // wMaxPacketSize
            HIBYTE( AUDIO_EP_SIZE( IN_tUpperSamFreq, IN_BitResolution , IN_Channel)),
        #else
            LOBYTE( AUDIO_EP_SIZE2( IN_tUpperSamFreq, IN_BitResolution , IN_Channel)),     // wMaxPacketSize
            HIBYTE( AUDIO_EP_SIZE2( IN_tUpperSamFreq, IN_BitResolution , IN_Channel)),
        #endif
        0x01,
        0x00,
        0x00,
        //----------------------------------------------
        0x07,
        CS_ENDPOINT_DESCRIPTOR,
        AS_INTERFACE_SUBTYPE_GENERAL,
        0x01,
        0x00,
        0x00,
        0x00,
        
    #endif
    
    //============================================= 
    // Audio Control HID interface 
    #if 1
        0x09,
        INTERFACE_DESCRIPTOR,
        0x04,
        0x00,
        0x01,
        0x03,
        0x00,
        0x00,
        0x00,
        //----------------------------------------------
        0x09,
        HID_DESCRIPTOR,
        0x00,
        0x01,
        0x00,
        0x01,
        0x22,
        LOBYTE( HID_REPORT2_SIZE ),                  
        HIBYTE( HID_REPORT2_SIZE ),                   
        //----------------------------------------------
        0x07,
        ENDPOINT_DESCRIPTOR,
        (USB_EP_IN | USB_EP_7), 
        (USB_EP_INTERRUPT | USB_EP_NO_SYNC | USB_EP_DATA), 
        0x10,
        0x00,
        0x02,
    #endif
    
    
};

/**
 ***************************************************************************************************************
 * @fn       	STRING Descriptor  relationship 
 * @param    	
 * @return      
 * @details    	//-----------------USB 2.0------------------------------
				0:		bLength				Number		Size of this descriptor in bytes
				1:		bDescriptorType		Constant	STRING Descriptor Type
				2:		wLANGID[0]          Number      LANGID code zero
				...
				N		wLANGID[N]          Number      LANGID code x
***************************************************************************************************************
 */ 
const uint8_t USB_STRING_DESCRIPTOR[] = 
{
	0x04,										// 0: Computed byt subtraction two from the value of the first byte of the descriptor
	STRING_DESCRIPTOR,							// 1: Descriptor Type
	0x09,										// 2:
	0x04    
};


#define MFS_LEN sizeof("Megawin Technology Inc.")*2
//-----MANUFACTURER(UNICODE) in String Descriptor-----//
const uint8_t MANUFACTURER_DESCRIPTOR[]=
  { MFS_LEN,
    0x03,                                        // Descriptor Type
    'M',0x00,
    'e',0x00,
    'g',0x00,
    'a',0x00,
    'w',0x00,
    'i',0x00,
    'n',0x00,
    ' ',0x00,
    'T',0x00,
    'e',0x00,
    'c',0x00,
    'h',0x00,
    'n',0x00,
    'o',0x00,
    'l',0x00,
    'o',0x00,
    'g',0x00,
    'y',0x00,
    ' ',0x00,
    'I',0x00,
    'n',0x00,
    'c',0x00,
    '.',0x00
  };


#define PDS_LEN sizeof("Sample Audio")*2
//-----PRODUCT(UNICODE) in String Descriptor-----//
const uint8_t PRODUCT_DESCRIPTOR[]=
  { PDS_LEN,
    0x03,                                        // Descriptor Type
    'S',0x00,
    'a',0x00,
    'm',0x00,
    'p',0x00,
    'l',0x00,
    'e',0x00,
    ' ',0x00,
    'A',0x00,
    'u',0x00,
    'd',0x00,
    'i',0x00,
    'o',0x00,
  };


#define SNS_LEN sizeof("123456")*2
//-----Serial Number in String Descriptor-----//
const uint8_t SERIALNUMBER_DESCRIPTOR[]=
  { SNS_LEN,
    0x03,                                        // Descriptor Type
    '1',0x00,
    '2',0x00,
    '3',0x00,
    '4',0x00,
    '5',0x00,
    '6',0x00
  };



/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/









